#!/bin/sh

# Requirements:
#  * rpmbuild

set -e


DIR=$(dirname "$(readlink -f "$0")")

rm -rf "$DIR/../repo"

for spec in $DIR/*.spec; do
    for target in i686 x86_64 s390x; do
        if [ "$(basename "$spec")" = "dummy-foo32.spec" ]; then
            if [ "$target" = "x86_64" -o "$target" = "s390x" ]; then
                continue
            fi
        fi
        if [ "$(basename "$spec")" = "dummy-glibc-2.14-4.spec" ]; then
            if [ "$target" = "i686" ]; then
                continue
            fi
        fi
        rpmbuild --quiet --target=$target -ba --nodeps --define "_srcrpmdir $DIR/../repo/src" --define "_rpmdir $DIR/../repo" "$spec"
    done
done

for compose in "$DIR"/../composes/*; do
    grep '"path"' "$compose/compose/metadata/rpms.json" | cut -d '"' -f4 | while read PTH; do
        FNAME=$(basename "$PTH")
        DEST="$compose/compose/$PTH"
        mkdir -p "$(dirname "$DEST")"
        cp "$(find "$DIR/../repo" -name "$FNAME")" "$DEST"
    done
done
