# -*- encoding: utf-8 -*-

import unittest
import os
import StringIO
import sys

import productmd.compose

sys.path.insert(0, os.path.join(os.path.dirname(__file__), '..'))

from compose_utils.legacy import write_legacy_composeinfo


BASE_PATH = os.path.join(os.path.dirname(__file__), 'composes', 'DP-1.0-20160720.t.8')


def get_expected(pref=''):
    import pkg_resources
    from distutils.version import LooseVersion
    try:
        productmd_ver = LooseVersion(pkg_resources.get_distribution('productmd').version)
        if productmd_ver == LooseVersion('1.1'):
            return pref + '.productmd11.composeinfo'
    except pkg_resources.DistributionNotFound:
        pass
    return pref + '.composeinfo'


class LegacyComposeInfoTest(unittest.TestCase):

    def setUp(self):
        self.compose = productmd.compose.Compose(BASE_PATH)

    def test_write_legacy_file(self):
        output = StringIO.StringIO()
        write_legacy_composeinfo(self.compose.info, output)
        with open(os.path.join(BASE_PATH, 'compose', get_expected())) as f:
            expected = f.read().split()
            self.assertEqual(output.getvalue().split(), expected)

    def test_write_legacy_file_no_paths(self):
        output = StringIO.StringIO()
        # Keep only Server variant and remove all paths for server
        server = self.compose.info.variants['Server']
        server.variants = {}
        self.compose.info.variants.variants = {'Server': server}
        for type in self.compose.info.variants['Server'].paths._fields:
            setattr(self.compose.info.variants['Server'].paths, type, {})

        write_legacy_composeinfo(self.compose.info, output)
        with open(os.path.join(BASE_PATH, 'compose', get_expected('.empty'))) as f:
            expected = f.read().split()
            self.assertEqual(output.getvalue().split(), expected)


if __name__ == '__main__':
    unittest.main()
