# -*- encoding: utf-8 -*-

import json
import unittest

from .helpers import get_compose, get_fixture

from compose_utils.package_moves import ComposePackageMoves


class ReportMoveTest(unittest.TestCase):

    def setUp(self):
        with open(get_fixture('move-report.json')) as f:
            self.expected = json.load(f)

    def test_package_moves(self):
        old_compose = get_compose('DP-1.0-20160315.t.0')
        new_compose = get_compose('DP-1.0-20160315.t.2')

        cpm = ComposePackageMoves()

        data = cpm.get_report(old_compose, new_compose)
        self.maxDiff = None
        self.assertEqual(data, self.expected)


if __name__ == '__main__':
    unittest.main()
