#!/usr/bin/env python
# -*- encoding: utf-8 -*-

from setuptools import setup

setup(
    name='compose-utils',
    version='0.1.19',
    description='Utilities for working with composes',
    url='https://pagure.io/compose-utils',
    author='Lubomír Sedlář',
    author_email='lsedlar@redhat.com',
    license='GPLv2',
    packages=[
        'compose_utils',
    ],
    scripts=[
        'bin/compose-changelog',
        'bin/compose-create-legacy-composeinfo',
        'bin/compose-latest-symlink',
        'bin/compose-list',
        'bin/compose-partial-copy',
        'bin/compose-report-package-moves',
    ],
    install_requires=[
        'productmd>=1.0',
        'kobo>=0.4.2',
        'six',
    ],
    data_files=[
        ('share/man/man1', [
            'doc/compose-changelog.1',
            'doc/compose-create-legacy-composeinfo.1',
            'doc/compose-list.1',
            'doc/compose-partial-copy.1',
            'doc/compose-report-package-moves.1',
        ]),
    ],
    include_package_data=True,
    test_suite='nose.collector',
    tests_require=[
        'nose',
        'mock',
        'freezegun',
        'unittest2',
    ],
)
