# -*- encoding: utf-8 -*-

import os
import productmd.compose


def get_compose_path(ident):
    """Given a compose ID, return path to that compose."""
    base = os.path.dirname(__file__)
    pth = os.path.join(base, 'composes', ident)
    return pth


def get_compose(ident, path=None):
    """Load a test compose and return the Compose instance."""
    path = path or get_compose_path(ident)
    return productmd.compose.Compose(path)


def get_fixture(filename):
    base = os.path.dirname(__file__)
    return os.path.join(base, 'fixtures', filename)
