"""Setuptools-based setup script."""

from os import path
from setuptools import setup

HERE = path.abspath(path.dirname(__file__))

# Get the long description from the README file
with open(path.join(HERE, 'README.md'), encoding='utf-8') as readfh:
    LONGDESC = readfh.read()

# and the deps
with open(path.join(HERE, 'install.requires'), encoding='utf-8') as reqfh:
    INSTALLREQS = reqfh.read().splitlines()

setup(
    name="relval",
    version="2.7.7",
    entry_points={'console_scripts': ['relval = relval.cli:main'],},
    author="Adam Williamson",
    author_email="awilliam@redhat.com",
    description="Fedora QA wiki test validation event management tool",
    license="GPLv3+",
    keywords="fedora qa mediawiki validation",
    url="https://pagure.io/fedora-qa/relval",
    packages=["relval"],
    include_package_data=True,
    package_dir={"": "src"},
    install_requires=INSTALLREQS,
    python_requires="!=3.0.*, !=3.1.*, !=3.2.*, !=3.3.*, !=3.4.*, !=3.5.*, <4",
    long_description=LONGDESC,
    long_description_content_type='text/markdown',
    classifiers=[
        "Development Status :: 5 - Production/Stable",
        "Topic :: Utilities",
        "License :: OSI Approved :: GNU General Public License v3 or later (GPLv3+)",
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3.6",
        "Programming Language :: Python :: 3.7",
        "Programming Language :: Python :: 3.8",
        "Programming Language :: Python :: 3.9",
    ],
)
