# Copyright Red Hat
#
# This file is part of relval.
#
# relval is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# Authors:
# Brandon Nielsen <nielsenb@jetfuse.net>
# Adam Williamson <awilliam@redhat.com>

"""Test fixtures."""

from unittest.mock import Mock, patch

import pytest


@pytest.fixture
def mock_page_one():
    """Provides a mock wiki page with a single result."""
    mock_test_result = Mock()
    mock_test_result.secid = "test 1"
    mock_test_result.results = {"1": None}
    mock_test_result.testcase = "test case"

    with patch("relval.report_results.PAGE") as mock_page:
        mock_page.name = "test page"
        mock_page.get_resultrows.return_value = [mock_test_result]
        yield (mock_test_result, mock_page)


@pytest.fixture
def mock_page_two():
    """Provides a mock wiki page with two results."""
    mock_test1_result = Mock()
    mock_test1_result.secid = "test 1"
    mock_test1_result.results = {"1": None}
    mock_test1_result.testcase = "test case"
    mock_test1_result.name = "test name 1"

    mock_test2_result = Mock()
    mock_test2_result.secid = "test 1"
    mock_test2_result.results = {"1": None}
    mock_test2_result.testcase = "test case"
    mock_test2_result.name = "test name 2"

    with patch("relval.report_results.PAGE") as mock_page:
        mock_page.name = "test page"
        mock_page.get_resultrows.return_value = [mock_test1_result, mock_test2_result]
        yield (mock_test1_result, mock_test2_result, mock_page)


@pytest.fixture
def mock_event_res_pages():
    """Mocks an Event with a single result page."""
    mock_test_result = Mock()
    mock_test_result.secid = "test 1"
    mock_test_result.results = {"1": None}
    mock_test_result.testcase = "test case"

    mock_page = Mock()
    mock_page.name = "test page"
    mock_page.testtype = "testtesttype"
    mock_page.get_resultrows.return_value = [mock_test_result]

    mock_event = Mock()
    mock_event.result_pages = [mock_page]

    yield (mock_test_result, mock_page, mock_event)
