<?php 

class magazine_recent_widget extends WP_Widget {

	function __construct() {
		$widget_ops = array(
			'classname'   => 'magazine_recent_widget',
			'description' => 'Displays recent posts.'
		);
		parent::__construct( 'magazine_recent_widget', 'Magazine Recent posts widget', $widget_ops );
	}
	
	function widget($args, $instance) {
			// Outputs the content of the widget
		extract($args); // Make before_widget, etc available.
		
		$widget_title = apply_filters('widget_title', $instance['widget_title']);
		$fli_id = $instance['id'];
		$fli_number = $instance['number'];
		$unique_id = $args['widget_id'];
		$terms = get_the_terms($GLOBALS['post']->ID, 'post_series');
		#don't show this widget if it is part of a post series
		if (!(is_array($terms))){
		echo $before_widget;

		?>
			<p class="related-posts-title">Recent Posts <i class="fa fa-arrow-right" aria-hidden="true"></i></p>
			<?php
			$args = array( 'numberposts' => '4',  'post_status' => 'publish');
			$recent_posts = wp_get_recent_posts( $args );
			$recentcount = 0;
			foreach( $recent_posts as $recent ){
				if ($GLOBALS['post']->ID != $recent["ID"]){
					if ($recentcount >= 3) {
						break;
					} else {
                        $image = get_the_post_thumbnail( $recent["ID"], 'post-image-thumb' );
                        echo '<a class="related-post" href="' . get_permalink($recent["ID"]) . '">
                            '.$image.'<h3 class="title">'.$recent["post_title"].'</h3>
                                  </a>';
						$recentcount = $recentcount+1;
					}
				}
			}
			?>
	<?php echo $after_widget; 
		}
	}
	
	
	function update($new_instance, $old_instance) {
	
		//update and save the widget
		return $new_instance;
		
	}
	
	function form($instance) {
	
	}
}
register_widget('magazine_recent_widget'); ?>
