#!/bin/sh

set -e

HERE=$(pwd)/$(dirname "$0")
PATH="$HERE/../bin:$HERE/bin:$PATH"
export PATH
RET=0

for t in $HERE/test_*; do
    output=$(mktemp)
    diff=$(mktemp)
    cd "$t"
    fedpkg sources >"$output"
    if diff -u expected "$output" >"$diff"; then
        printf "%-40s 0K\n" "$(basename "$t")"
    else
        printf "%-40s FAIL\n" "$(basename "$t")"
        echo "DIFF:"
        cat "$diff"
        echo ""
        RET=$((RET + 1))
    fi
    cd "$HERE"
    rm -f "$output" "$diff"
done
exit $RET
