# fedpkg - a Python library for RPM Packagers
#
# Copyright (C) 2022 Red Hat Inc.
# Author(s): Aurélien Bompard <aurelien@bompard.org>
#
# This program is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by the
# Free Software Foundation; either version 2 of the License, or (at your
# option) any later version.  See http://www.gnu.org/copyleft/gpl.html for
# the full text of the license.

from bodhi.client.bindings import BodhiClient as BodhiClient_
from bodhi.client.constants import UPDATE_TYPES, REQUEST_TYPES, SUGGEST_TYPES  # noqa


class BodhiClient(BodhiClient_):

    def __init__(self, username, *args, **kwargs):
        super().__init__(*args, **kwargs)

    def extend_override(self, override, new_expiration_date):
        return self.save_override(
            nvr=override["nvr"],
            notes=override["notes"],
            expiration_date=new_expiration_date
        )
