# -*- coding: utf-8 -*-
# completers.py - custom argument completers module for fedpkg
#
# Copyright (C) 2019 Red Hat Inc.
# Author(s): Ondrej Nosek <onosek@redhat.com>,
#            Dominik Rumian <drumian@redhat.com>
#
# This program is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by the
# Free Software Foundation; either version 2 of the License, or (at your
# option) any later version.  See http://www.gnu.org/copyleft/gpl.html for
# the full text of the license.

import os
import subprocess
import sys

from argcomplete.completers import ChoicesCompleter


def distgit_branches(**kwargs):
    format = "--format=%(refname:short)"
    # TODO: Somehow get $path from argument-string
    git_remotes = subprocess.Popen(
        ("git", "for-each-ref", format, "refs/remotes"),
        stdout=subprocess.PIPE)
    remotes = subprocess.check_output(
        ("sed", "s,.*/,,"),
        stdin=git_remotes.stdout)
    git_remotes.wait()
    git_remotes.stdout.close()

    heads = subprocess.check_output(
        ("git", "for-each-ref", format, "refs/heads"))

    return remotes.decode(sys.stdout.encoding).split() \
        + heads.decode(sys.stdout.encoding).split()


def fedpkg_packages(prefix, **kwargs):
    if len(prefix):
        FNULL = open(os.devnull, 'wb')
        repoquery = subprocess.Popen(
            ("repoquery", "-C", "--qf=%{sourcerpm}", "{}*".format(prefix)),
            stdout=subprocess.PIPE,
            stderr=FNULL)
        output = subprocess.check_output(
            ("sed", "-r", "s/(-[^-]*){2}\\.src\\.rpm$//"),
            stdin=repoquery.stdout)
        repoquery.wait()
        repoquery.stdout.close()

        return tuple(output.decode(sys.stdout.encoding).split())
    else:
        return []


def list_targets(**kwargs):
    FNULL = open(os.devnull, 'wb')
    brew = subprocess.Popen(
        ("koji", "list-targets", "--quiet"),
        stdout=subprocess.PIPE,
        stderr=FNULL)
    output = subprocess.check_output(
        ("cut", "-d ", "-f1"),
        stdin=brew.stdout)
    brew.wait()
    brew.stdout.close()

    return tuple(output.decode(sys.stdout.encoding).split())


build_arches = ChoicesCompleter(("aarch64", "armhfp", "i686", "ppc64le",
                                 "s390x", "x86_64"))
