FROM fedora:42
LABEL \
    name="fedpkg test" \
    description="Run tests using tox with Python 3" \
    vendor="fedpkg developers" \
    license="MIT"

RUN dnf -y update && dnf -y install \
        python3-setuptools \
        rpm-build \
        python3-tox \
        python3.6 \
        gcc \
        libcurl-devel \
        krb5-devel \
        openssl-devel \
        make \
        git \
        ruff
RUN dnf clean all

WORKDIR /src

ENV PYTHONPATH "${PYTHONPATH}:./rpkg"

CMD ["tox", "-e", "py36,py39,py312,py313,py314,flake8,ruff"]
