#!/usr/bin/python

import os

from setuptools import find_packages, setup


project_dir = os.path.dirname(os.path.realpath(__file__))
requirements = os.path.join(project_dir, 'requirements.txt')
tests_requirements = os.path.join(project_dir, 'tests-requirements.txt')

with open(requirements, 'r') as f:
    install_requires = [line.strip() for line in f]
install_requires += [
    'distro',
]

with open(tests_requirements, 'r') as f:
    tests_require = [line.strip() for line in f]


setup(
    name="fedpkg",
    version="1.47",
    author="Dennis Gilmore",
    author_email="dgilmore@fedoraproject.org",
    description=("Fedora plugin to rpkg to manage "
                 "package sources in a git repository"),
    license="GPLv2+",
    url="https://pagure.io/fedpkg",
    packages=find_packages(),
    data_files=[('/etc/rpkg', ['conf/etc/rpkg/fedpkg.conf',
                               'conf/etc/rpkg/fedpkg-stage.conf']),
                ],

    install_requires=install_requires,
    tests_require=tests_require,

    entry_points={
        'console_scripts': [
            'fedpkg = fedpkg.__main__:main',
            'fedpkg-stage = fedpkg.__main__:main',
        ],
    },

    classifiers=[
        'Development Status :: 5 - Production/Stable',
        'Environment :: Console',
        'Intended Audience :: Developers',
        'Topic :: Software Development :: Build Tools',
        'License :: OSI Approved :: GNU General Public License v2 or later (GPLv2+)',
        'Programming Language :: Python :: 3',
        'Programming Language :: Python :: 3.6',
        'Programming Language :: Python :: 3.9',
        'Programming Language :: Python :: 3.12',
        'Programming Language :: Python :: 3.13',
        'Programming Language :: Python :: 3.14',
    ],
)
