// Data types
import { DNSRecord } from "./datatypes/globalDataTypes";
import { convertApiObj } from "src/utils/ipaObjectUtils";

export const dnsRecordAsRecord = (
  element: Partial<DNSRecord>,
  onElementChange: (element: Partial<DNSRecord>) => void
) => {
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  const ipaObject = element as Record<string, any>;
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  function recordOnChange(ipaObject: Record<string, any>) {
    onElementChange(ipaObject as DNSRecord);
  }
  return { ipaObject, recordOnChange };
};

const simpleValues = new Set([
  "idnssoarefresh",
  "idnssoaretry",
  "idnssoaexpire",
  "idnssoaminimum",
  "idnssoaserial",
  "idnsupdatepolicy",
  "idnsallowdynupdate",
  "idnsallowquery",
  "idnsallowtransfer",
  "idnszoneactive",
  "dn",
  "dnsrecord_types",
  "dnsrecord_data",
  // - Extended values
  "dnsttl",
  "dnsclass",
  "dnstype",
  "dnsdata",
  "a_extra_create_reverse",
  "aaaa_part_ip_address",
  "aaaa_extra_create_reverse",
  "a6_part_data",
  "afsdb_part_subtype",
  "afsdb_part_hostname",
  "cert_part_type",
  "cert_part_key_tag",
  "cert_part_algorithm",
  "cert_part_certificate_or_crl",
  "cname_part_hostname",
  "dlv_part_key_tag",
  "dlv_part_algorithm",
  "dlv_part_digest_type",
  "dlv_part_digest",
  "dname_part_target",
  "ds_part_key_tag",
  "ds_part_algorithm",
  "ds_part_digest_type",
  "ds_part_digest",
  "kx_part_preference",
  "kx_part_exchanger",
  "loc_part_lat_deg",
  "loc_part_lat_min",
  "loc_part_lat_sec",
  "loc_part_lat_dir",
  "loc_part_lon_deg",
  "loc_part_lon_min",
  "loc_part_lon_sec",
  "loc_part_lon_dir",
  "loc_part_altitude",
  "loc_part_size",
  "loc_part_h_precision",
  "loc_part_v_precision",
  "mx_part_preference",
  "mx_part_exchanger",
  "naptr_part_order",
  "naptr_part_preference",
  "naptr_part_flags",
  "naptr_part_service",
  "naptr_part_regexp",
  "naptr_part_replacement",
  "ns_part_hostname",
  "ptr_part_hostname",
  "srv_part_priority",
  "srv_part_weight",
  "srv_part_port",
  "srv_part_target",
  "sshfp_part_algorithm",
  "sshfp_part_fp_type",
  "sshfp_part_fingerprint",
  "tlsa_part_cert_usage",
  "tlsa_part_selector",
  "tlsa_part_matching_type",
  "tlsa_part_cert_association_data",
  "txt_part_data",
  "uri_part_priority",
  "uri_part_weight",
  "uri_part_target",
]);
const dateValues = new Set([]);
const complexValues = new Map([
  ["idnsname", "__dns_name__"],
  ["idnssoarname", "__dns_name__"],
  ["idnssoamname", "__dns_name__"],
]);

export function apiToDnsRecord(apiRecord: Record<string, unknown>): DNSRecord {
  const converted = convertApiObj(
    apiRecord,
    simpleValues,
    dateValues,
    complexValues
  ) as Partial<DNSRecord>;
  return partialDnsRecordToDnsRecord(converted);
}

export function partialDnsRecordToDnsRecord(
  partialDnsRecord: Partial<DNSRecord>
) {
  return {
    ...createEmptyDnsRecord(),
    ...partialDnsRecord,
  };
}

export function createEmptyDnsRecord(): DNSRecord {
  return {
    idnsname: "",
    idnssoarname: "",
    idnssoamname: "",
    idnssoarefresh: 0,
    idnssoaretry: 0,
    idnssoaexpire: 0,
    idnssoaminimum: 0,
    idnssoaserial: 0,
    idnsupdatepolicy: "",
    idnsallowdynupdate: false,
    idnsallowquery: "",
    idnsallowtransfer: "",
    idnszoneactive: false,
    dn: "",
    dnsrecords: [],
    dnsrecord_types: "",
    dnsrecord_data: "",
    // - Extended values
    dnsttl: 0,
    dnsclass: "",
    dnstype: "",
    dnsdata: "",
    arecord: [],
    a_part_ip_address: [],
    a_extra_create_reverse: false,
    aaaarecord: [],
    aaaa_part_ip_address: "",
    aaaa_extra_create_reverse: false,
    a6record: [],
    a6_part_data: "",
    afsdbrecord: [],
    afsdb_part_subtype: 0,
    afsdb_part_hostname: "",
    aplrecord: [],
    certrecord: [],
    cert_part_type: 0,
    cert_part_key_tag: 0,
    cert_part_algorithm: 0,
    cert_part_certificate_or_crl: "",
    cnamerecord: [],
    cname_part_hostname: "",
    dhcidrecord: [],
    dlvrecord: [],
    dlv_part_key_tag: 0,
    dlv_part_algorithm: 0,
    dlv_part_digest_type: 0,
    dlv_part_digest: "",
    dnamerecord: [],
    dname_part_target: "",
    dsrecord: [],
    ds_part_key_tag: 0,
    ds_part_algorithm: 0,
    ds_part_digest_type: 0,
    ds_part_digest: "",
    hiprecord: [],
    ipseckeyrecord: [],
    keyrecord: [],
    kxrecord: [],
    kx_part_preference: 0,
    kx_part_exchanger: "",
    locrecord: [],
    loc_part_lat_deg: 0,
    loc_part_lat_min: 0,
    loc_part_lat_sec: 0.0,
    loc_part_lat_dir: "N",
    loc_part_lon_deg: 0,
    loc_part_lon_min: 0,
    loc_part_lon_sec: 0.0,
    loc_part_lon_dir: "E",
    loc_part_altitude: 0.0,
    loc_part_size: 0.0,
    loc_part_h_precision: 0.0,
    loc_part_v_precision: 0.0,
    mxrecord: [],
    mx_part_preference: 0,
    mx_part_exchanger: "",
    naptrrecord: [],
    naptr_part_order: 0,
    naptr_part_preference: 0,
    naptr_part_flags: "S",
    naptr_part_service: "",
    naptr_part_regexp: "",
    naptr_part_replacement: "",
    nsrecord: [],
    ns_part_hostname: "",
    nsecrecord: [],
    ptrrecord: [],
    ptr_part_hostname: "",
    rrsigrecord: [],
    rprecord: [],
    sigrecord: [],
    spfrecord: [],
    srvrecord: [],
    srv_part_priority: 0,
    srv_part_weight: 0,
    srv_part_port: 0,
    srv_part_target: "",
    sshfprecord: [],
    sshfp_part_algorithm: 0,
    sshfp_part_fp_type: 0,
    sshfp_part_fingerprint: "",
    tlsarecord: [],
    tlsa_part_cert_usage: 0,
    tlsa_part_selector: 0,
    tlsa_part_matching_type: 0,
    tlsa_part_cert_association_data: "",
    txtrecord: [],
    txt_part_data: "",
    urirecord: [],
    uri_part_priority: 0,
    uri_part_weight: 0,
    uri_part_target: "",
  };
}
